// ListList_CPP V7Dlg.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include <Mmsystem.h> // timeGetTime
#include "ListList_CPP V7.h"
#include "ListList_CPP V7Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CListList_CPPV7Dlg Dialogfeld



CListList_CPPV7Dlg::CListList_CPPV7Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CListList_CPPV7Dlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	RootDir = NULL;
}

CListList_CPPV7Dlg::~CListList_CPPV7Dlg()
{
	if (RootDir) delete RootDir;
}

void CListList_CPPV7Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST4, ListBox1);
	DDX_Control(pDX, IDC_BUTTON1, bCreateTree);
	DDX_Control(pDX, IDC_BUTTON2, bBenchCreate);
}

BEGIN_MESSAGE_MAP(CListList_CPPV7Dlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, OnBnClickedbCreateTree)
	ON_BN_CLICKED(IDC_BUTTON2, OnBnClickedbBenchCreate)
END_MESSAGE_MAP()


// CListList_CPPV7Dlg Meldungshandler

BOOL CListList_CPPV7Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
	//  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden

	// TODO: Hier zustzliche Initialisierung einfgen
	
	return TRUE;  // Geben Sie TRUE zurck, auer ein Steuerelement soll den Fokus erhalten
}

// Wenn Sie dem Dialogfeld eine Schaltflche "Minimieren" hinzufgen, bentigen Sie 
//  den nachstehenden Code, um das Symbol zu zeichnen. Fr MFC-Anwendungen, die das 
//  Dokument/Ansicht-Modell verwenden, wird dies automatisch ausgefhrt.

void CListList_CPPV7Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // Gertekontext zum Zeichnen

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Symbol in Clientrechteck zentrieren
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Symbol zeichnen
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// Die System ruft diese Funktion auf, um den Cursor abzufragen, der angezeigt wird, whrend der Benutzer
//  das minimierte Fenster mit der Maus zieht.
HCURSOR CListList_CPPV7Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

// Anzeige in der Listbox, auch fr Suchergebnisse
void CListList_CPPV7Dlg::ShowEntry(const CString& S)
{
  ListBox1.AddString(S);
}


// Ausgabe der Demo-Liste (100 Elemente)
void CListList_CPPV7Dlg::PrintListList(CSingleEntry* List, int Level)
{ CString Lead = "";
  CSingleEntry* E;

  for (int x = 1; x < Level; x++)
	  Lead = Lead + "  ";
  // EntryName+' (LIST) fr Verzeichnisse
  ShowEntry(Lead + List->GetDisplayName());

  // Dateieintrge und Verzeichnisse, ungeordnet
  for (int x = 0; ; x++)
  {
	  E = List->GetEntry(x);
	  if (!E) break;
	  PrintListList(E, Level+1);
  }
}

// Listenaufbau (rekursiv)
void CListList_CPPV7Dlg::BuildListList(CSingleEntry* List, int Level)
{ int LocalCount, NameLength;
  char BuildNN [10];

  // maximal 25 Eintrge pro Liste - nur das Stammverzeichnis
  // kann mehr haben
  LocalCount = rand() % 25  + 1;

  for (int x = 1; x <= LocalCount; x++)
  {
	EntryCount--;
	// zuflliger Name mit 1-8 Zeichen
    NameLength = rand() % 8 + 1;
	int y;  
    for (y = 0; y < NameLength; y++)
		BuildNN[y] = char((int)'a' + (rand() % 26));
	BuildNN[y] = 0; 
    CString NewName(BuildNN);

    // Einzelner Eintrag oder neue Liste? Die Wahrscheinlichkeit
    // fr neue Listen (und weitere Rekursion) sinkt mit zunehmender
    // Verschachelungstiefe
    if (rand() % (10*Level) < 1)
        BuildListList(List->AddNode(NewName), Level+1); // new list
      else List->AddEntry(NewName);
    if (EntryCount == 0)
		break;
  }
}

void CListList_CPPV7Dlg::ClearList()
{
  if (RootDir) delete RootDir;
  RootDir = NULL; 
}

// Legt die Elementenzahl fest und erzeugt das Stammverzeichnis
void CListList_CPPV7Dlg::BuildBaseList(int ECount)
{ 
  if (RootDir == NULL) RootDir = new CListEntry("C:");
  EntryCount = ECount;
  // irgendein Startwert fr rand()
  srand((unsigned)time(NULL)); 

  while (EntryCount > 0)
	BuildListList(RootDir,1);	   
}

// =======================================================
CString CListList_CPPV7Dlg::FindListEntry(CListEntry* List, const CString& SubStr)
{ CSingleEntry* Result = List->FindEntry(SubStr);

  if (Result != NULL) return Result->FullName();
	else return "";
}

// ================================================

// Demo-Liste mit 100 Elementen, Anzeige
void CListList_CPPV7Dlg::OnBnClickedbCreateTree()
{ 
  ListBox1.ResetContent();
  ClearList();
  BuildBaseList(100);
  PrintListList(RootDir, 1);
}

// 1 Million Objekte, 100 Millionen Suchvorgnge
void CListList_CPPV7Dlg::OnBnClickedbBenchCreate()
{

	ListBox1.ResetContent(); ListBox1.UpdateWindow();
	DWORD fullBench = 0;
	DWORD constructionTime = 0;
	DWORD destructionTime = 0;
	DWORD findTime = 0;      
	DWORD meanTime; 
	DWORD STime = timeGetTime();

#ifdef _DEBUG
#define ECOUNT 10000
	ShowEntry("*** DEBUG: using 10.000 entries");
#else
#define ECOUNT 100000
#endif
  	
	for (int x = 1; x <= 10; x++)
	{
		meanTime = timeGetTime();
		ClearList();                       // Destruktion
		destructionTime += (timeGetTime() - meanTime); 
		meanTime = timeGetTime();
		BuildBaseList(ECOUNT);             // Konstruktion
		constructionTime += (timeGetTime() - meanTime); 
		meanTime = timeGetTime();
		// Suchen
		ShowEntry("Search a: " + FindListEntry(RootDir, "a"));
		ShowEntry("Search ax: " + FindListEntry(RootDir, "ax"));
		ShowEntry("Search axv: " + FindListEntry(RootDir, "axv"));
		ShowEntry("Search axve: " + FindListEntry(RootDir, "axve"));

		for (int y = 1; y <= 20; y++)
		FindListEntry(RootDir,"X"); // gibts nicht  
	    findTime += (timeGetTime() - meanTime); 
		ListBox1.UpdateWindow();
	}

	CString Msg;
	Msg += (CString("Time:\t\t") + DWORDToTime(timeGetTime()-STime)); 
	Msg += (CString("\nfor Construction:\t") + DWORDToTime(constructionTime));
	Msg += (CString("\nfor Destruction:\t") + DWORDToTime(destructionTime));
	Msg += (CString("\nfor Find:\t\t") + DWORDToTime(findTime));
	AfxMessageBox(Msg);
}
CString CListList_CPPV7Dlg::DWORDToTime(DWORD Millisecs)
{
	DWORD std, min, sec, ms; 
	std = Millisecs / 3600000; 
	min = Millisecs % 3600000 / 60000; 
	sec = Millisecs % 60000 / 1000;
	ms = Millisecs % 1000;
	CString s; 
	s.Format("%.2d:%.2d:%.2d.%.3d", std, min, sec, ms);
	return s; 
}